<?php
if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/thanks/includes/class_template.php');
}

/**
* Thanks Block for Advanced Post Thanks / Like
*
* @package Advanced Post Thanks / Like
*/
class vB_ProfileBlock_APTL_Thanks extends vB_ProfileBlock
{
	/**
	* The name of the template to be used for the block
	*
	* @var string
	*/
	var $template_name = 'dbtech_thanks_memberinfo_block_thanks';
	
	var $nowrap = true;
	
	var $skip_privacy_check = true;
	
	/**
	* Variables to automatically prepare
	*
	* @var array
	*/
	var $auto_prepare = array();

	/**
	* Sets/Fetches the default options for the block
	*
	*/
	function fetch_default_options()
	{
		$this->option_defaults = array(
			'pagenumber' => 1,
			'perpage'    => 25,
		);
	}

	/**
	* Whether to return an empty wrapper if there is no content in the blocks
	*
	* @return bool
	*/
	function confirm_empty_wrap()
	{
		return false;
	}

	/**
	* Whether or not the block is enabled
	*
	* @return bool
	*/
	function block_is_enabled($id)
	{
		return true;
	}

	/**
	* Prepare any data needed for the output
	*
	* @param	string	The id of the block
	* @param	array	Options specific to the block
	*/
	function prepare_output($id = '', $options = array())
	{
		global $show, $vbphrase;
		
		$lookup = array();
		foreach (THANKS::$cache['button'] as $button)
		{
			$lookup["$button[varname]"] = $button['title'];
		}		
		
		if (intval($this->registry->versionnumber) == 3)
		{
			$this->nowrap = false;
		}
		
		if ($this->profile->userinfo['userid'] == $this->registry->userinfo['userid'] AND $this->registry->userinfo['dbtech_thanks_alertcount'] AND $_REQUEST['tab'] == 'thanks')
		{
			// Reset tag count
			$this->registry->db->query_write("UPDATE " . TABLE_PREFIX . "user SET dbtech_thanks_alertcount = 0 WHERE userid = " . $this->registry->db->sql_prepare($this->registry->userinfo['userid']));
			$this->registry->userinfo['dbtech_thanks_alertcount'] = 0;
		}
		
		// Shorthands to faciliate easy copypaste
		$pagenumber = $options['pagenumber'];
		$perpage = $options['perpage'];
		$sortorder = 'DESC';
		$sqlsort = 'dateline';
		
		// Count number of users
		$count = $this->registry->db->query_first_slave("
			SELECT COUNT(*) AS total
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			LEFT JOIN " . TABLE_PREFIX . "post AS post ON(post.postid = entry.contentid)
			LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON(thread.threadid = post.threadid)
			$hook_query_join
			WHERE thread.forumid IN(" . implode(',', THANKS::fetch_forumids()) . ")
				AND (entry.userid = " . intval($this->profile->userinfo['userid']) . "
					OR entry.receiveduserid = " . intval($this->profile->userinfo['userid']) . ")
				$hook_query_where			
		");
		
		// Ensure every result is as it should be
		sanitize_pageresults($count['total'], $pagenumber, $perpage);
		
		// Find out where to start
		$startat = ($pagenumber - 1) * $perpage;
		
		// Constructs the page navigation
		$pagenav = construct_page_nav(
			$pagenumber,
			$perpage,
			$count['total'],
			'member.php?' . $this->registry->session->vars['sessionurl'] . "u=" . $this->profile->userinfo['userid'],
			"&amp;tab=$id&amp;perpage=$perpage"
		);
		
		// Page navigation registration
		$this->block_data['pagenav'] = $pagenav;		
		
		// Fetch users
		$results_q = $this->registry->db->query_read_slave("
			SELECT 
				post.postid,
				post.title AS posttitle,
				thread.title AS threadtitle,
				thread.title AS title,
				thread.threadid,
				entry.varname,			
				entry.dateline,			
				entry.userid,
				entry.receiveduserid,
				user.username,
				user.usergroupid,
				user.membergroupids,
				user.infractiongroupid,
				user.displaygroupid" . ($vbulletin->products['dbtech_vbshop'] ? ", user.dbtech_vbshop_purchase" : '') . ",
				receiveduser.username AS receivedusername,
				receiveduser.usergroupid AS receivedusergroupid,
				receiveduser.membergroupids AS receivedmembergroupids,
				receiveduser.infractiongroupid AS receivedinfractiongroupid,
				receiveduser.displaygroupid	 AS receiveddisplaygroupid
				" . ($vbulletin->products['dbtech_vbshop'] ? ", receiveduser.dbtech_vbshop_purchase AS receivedpurchase" : '') . "						
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			LEFT JOIN " . TABLE_PREFIX . "user AS user USING(userid)
			LEFT JOIN " . TABLE_PREFIX . "user AS receiveduser ON(receiveduser.userid = entry.receiveduserid)
			LEFT JOIN " . TABLE_PREFIX . "post AS post ON(post.postid = entry.contentid)
			LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON(thread.threadid = post.threadid)
			$hook_query_join
			WHERE thread.forumid IN(" . implode(',', THANKS::fetch_forumids()) . ")
				AND (entry.userid = " . intval($this->profile->userinfo['userid']) . "
					OR entry.receiveduserid = " . intval($this->profile->userinfo['userid']) . ")
			ORDER BY $sqlsort $sortorder, entry.userid
			LIMIT $startat, " . $perpage
		);
				
		// Ensure we got BBCode Parser
		require_once(DIR . '/includes/class_bbcode.php');
		
		// Initialise the parser (use proper BBCode)
		$parser = new vB_BbCodeParser($this->registry, fetch_tag_list());
		
		$results = array();
		while ($results_r = $this->registry->db->fetch_array($results_q))
		{
			// Ensure we have the proper day selected for the grouping
			$day = vbdate($this->registry->options['dateformat'], $results_r['dateline']);

			$received = array(
				'userid' 					=> $results_r['receiveduserid'],
				'username' 					=> $results_r['receivedusername'],
				'usergroupid' 				=> $results_r['receivedusergroupid'],
				'membergroupids' 			=> $results_r['receivedmembergroupids'],
				'infractiongroupid' 		=> $results_r['receivedinfractiongroupid'],
				'displaygroupid' 			=> $results_r['receiveddisplaygroupid'],
				'dbtech_vbshop_purchase' 	=> $results_r['receivedpurchase'],
			);
			
			// Grab the markup username
			fetch_musername($results_r);
			fetch_musername($received);
			
			if (intval($this->registry->versionnumber) == 4)
			{
				// vB4 have SEO URLs
				$link = fetch_seo_url('member', $results_r);
				$link2 = fetch_seo_url('member', $received);
			}
			else
			{
				// vB3 don't
				$link = "member.php?" . $this->registry->session->vars['sessionurl'] . "u=$results_r[userid]";
				$link2 = "member.php?" . $this->registry->session->vars['sessionurl'] . "u=$received[userid]";
			}
			
			// Determine what title to use
			$title = unhtmlspecialchars($results_r['posttitle'] ? $results_r['posttitle'] : $results_r['threadtitle']);

			$templater = vB_Template::create('dbtech_thanks_result_bit');
				$templater->register('text', construct_phrase($vbphrase['dbtech_thanks_x_clicked_y_for_z_post_a'],
					vbdate($this->registry->options['timeformat'], $results_r['dateline']) . ' - <a href="' . $link . '" target="_blank">' . $results_r['musername'] . '</a>',
					$lookup["$results_r[varname]"],
					$parser->parse('[post=' . $results_r['postid'] . ']' . $title . '[/post]', 'nonforum'),
					'<a href="' . $link2 . '" target="_blank">' . $received['musername'] . '</a>'
				));
			$results["$day"][] = $templater->render();
		}
		$this->registry->db->free_result($results_q);
		unset($results_r);		
		
		$resultbits = '';
		foreach ($results as $day => $result)
		{
			$templater = vB_Template::create('dbtech_thanks_result');
				$templater->register('day', $day);
				$templater->register('resultbits', implode('', $result));
			$resultbits .= $templater->render();
		}
		$this->block_data['resultbits'] = $resultbits;		
		
		// Make sure we can check the options
		//$this->block_data['options'] = $options;
	}
}